  Option Autorun On
  Option Explicit
  Option Default None
  
  'Header Tab Objects
  Const SwT1=1,SwT2=2,SwT3=3,SwT4=4
  'Tab 1 Objects
  Const C_TmpAmb=21,C_TmpPan=22,C_TmpCur=23,C_TmpInp=24,C_TmpOut=25,C_TmpDif=26,C_SlrVlt=27
  Const D_TmpAmb=31,D_TmpPan=32,D_TmpCur=33,D_TmpInp=34,D_TmpOut=35,D_TmpDif=36,D_SlrVlt=37
  'Tab 4 Objects
  Const D_Head4=80,F_SpaDat=81,F_HtpDat=82,L_Led1=83,L_Led2=84
  
  
  Dim String Esc=Chr$(27)
  Dim String DataStr,LastHpComs,LastScComs
  Dim Float TmpAmb,TmpPan,TmpCur,TmpInp,TmpOut,TmpDif,SlrVlt
  Dim Float TmpHpAir,TmpHpEva,TmpHpCmp,TmpHpInp,TmpHpOut,FlowRate
  Dim Integer ComDevNum=1,Led1Colour,LcdScrNum=1
  Dim Integer TabHgt,TabAct,Timer_L,Time_L
  
  Cls
  RTC GetTime
  
  SetupGui : Page 1,9
  
  Page 4,9 : TabAct=4
  CtrlVal(SwT1)=1
  CtrlVal(SwT2)=1
  CtrlVal(SwT3)=1
  CtrlVal(SwT4)=0
  UpdateTab4
  
  GUI Interrupt TouchDown
  
  Open "Com1:9600,,RecComs,140" as #1
  
  'LogData
    
  Do
    Timer_L=Timer
    If Timer Mod 500=0 Then UpdateTab4
    'Code Here
    If Timer Mod 1000=0 Then
      CtrlVal(D_TmpAmb)=Str$(TmpAmb,3,1)
      CtrlVal(D_TmpCur)=Str$(TmpCur,3,1)
      CtrlVal(D_TmpInp)=Str$(TmpInp,3,1)
      CtrlVal(D_TmpOut)=Str$(TmpOut,3,1)
      'TmpDif=TmpOut-TmpInp
      CtrlVal(D_TmpDif)=Str$(TmpOut-TmpInp,3,1)
      CtrlVal(D_TmpPan)=Str$(TmpPan,3,1)
      CtrlVal(10)="FlowRate"
    End If
    'If Timer Mod 300000=0 then LogData
    Time_L=Timer-Timer_L
  Loop
  
Sub Logdata
  
  OPEN "TestLog.txt" FOR Append AS #2
  Print #2, Time$;",";TmpAmb;",";TmpPan;",";TmpCur;",";TmpInp;",";TmpOut;",";TmpDif;",";SlrVlt
  Close #2
  
End Sub
  
Sub RecComs
  Local HdrLoc as integer
  Local HdrFnd As String
  
  If LOC(#1)>100 then 'If COM1 serial port buffer is NOT empty....
    Pause 50
    Print "Buffer Length=",Loc(#1)
    
    DataStr=INPUT$(LOC(#1),#1) 'then suck everything in the buffer out and stick it in D$....
    
    HdrLoc=Instr(DataStr,"##Data")
    If HdrLoc<>0 Then HdrFnd=Mid$(DataStr,HdrLoc,8)
    
    Print "Header Location",HdrLoc ',Instr(DataStr,"##HpData")
    Print "Header Found", HdrFnd
    Print DataStr 'and print that data on the screen.
    Print "Loop Time:- ";Timer-Timer_L
    Print "==========================================="
    'Pause 1000
    
    
    Select Case HdrFnd
      Case "##DataHp"
        'CtrlVal(L_Led2)=Not CtrlVal(L_Led2)
        CtrlVal(L_Led2)=500
        if Mid$(DataStr,HdrLoc+10,9)="TmpHpAir=" Then
          TmpHpAir=Val(MiD$(DataStr,HdrLoc+20,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+30,9)="TmpHpEva=" Then
          TmpHpEva=Val(Mid$(DataStr,HdrLoc+40,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+50,9)="TmpHpCmp=" Then
          TmpHpCmp=Val(Mid$(DataStr,HdrLoc+60,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+70,9)="TmpHpInp=" Then
          TmpHpInp=Val(Mid$(DataStr,HdrLoc+80,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+90,9)="TmpHpOut=" Then
          TmpHpOut=Val(Mid$(DataStr,HdrLoc+100,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+110,9)="FlowRate=" Then
          FlowRate=Val(Mid$(DataStr,HdrLoc+120,9))
        Else
          '      Print "Error"
        End If
        LastHpComs=Time$
        
      Case "##DataSc"
        
        'CtrlVal(L_Led1)=Not CtrlVal(L_Led1)
        CtrlVal(L_Led1)=500
        if Mid$(DataStr,HdrLoc+10,9)="TmpScAmb=" Then
          TmpAmb=Val(MiD$(DataStr,HdrLoc+20,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+30,9)="TmpScPan=" Then
          TmpPan=Val(Mid$(DataStr,HdrLoc+40,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+50,9)="TmpScCur=" Then
          TmpCur=Val(Mid$(DataStr,HdrLoc+60,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+70,9)="TmpScInp=" Then
          TmpInp=Val(Mid$(DataStr,HdrLoc+80,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+90,9)="TmpScOut=" Then
          TmpOut=Val(Mid$(DataStr,HdrLoc+100,9))
        Else
          '      Print "Error"
        End If
        if Mid$(DataStr,HdrLoc+110,9)="SolarVlt=") Then
          SlrVlt=Val(Mid$(DataStr,HdrLoc+120,9))
        Else
          '      Print "Error"
        End If
        LastScComs=Time$
        
    End Select
    
    
  End if
  
End Sub
  
  
  
  
Sub UpdateTab4
  
  IF TabAct=4 then
    
    Font 4,1
    Text MM.HRes/40, MM.VRes*5/16, "Air Temp    = ", LB,,, RGB(Cyan)
    Text MM.HRes/40, MM.VRes*6/16, "Water Temp  = ", LB,,, RGB(Green)
    Text MM.HRes/40, MM.VRes*7/16, "Input Temp  = ", LB,,, RGB(Blue)
    Text MM.HRes/40, MM.VRes*8/16, "Output Temp = ", LB,,, RGB(Red)
    Text MM.HRes/40, MM.VRes*9/16, "Temp Diff   = ", LB,,, RGB(Magenta)
    Text MM.HRes/40, MM.VRes*10/16, "Solar Volts = ", LB,,, RGB(Yellow)
    Text MM.HRes/40, MM.VRes*11/16, "Flow Rate l/m ", LB,,, RGB(Cyan)
    Text MM.HRes/40, MM.VRes*12/16, "Energy Watts  ", LB,,, RGB(255,165,0)
    
    Text MM.HRes*17/40, MM.VRes*5/16, Str$(TmpAmb,4,1), RB,,, RGB(Cyan)
    Text MM.HRes*17/40, MM.VRes*6/16, Str$(TmpCur,4,1), RB,,, RGB(Green)
    Text MM.HRes*17/40, MM.VRes*7/16, Str$(TmpInp,4,1), RB,,, RGB(Blue)
    Text MM.HRes*17/40, MM.VRes*8/16, Str$(TmpOut,4,1), RB,,, RGB(Red)
    Text MM.HRes*17/40, MM.VRes*9/16, Str$(TmpOut-TmpInp,4,1), RB,,, RGB(Magenta)
    Text MM.HRes*17/40, MM.VRes*10/16, Str$(SlrVlt,4,1), RB,,, RGB(Yellow)
    Text MM.HRes*17/40, MM.VRes*11/16, Str$(FlowRate,4,1), RB,,, RGB(Cyan)
    Text MM.HRes*17/40, MM.VRes*12/16, Str$((FlowRate*60*(TmpOut-TmpInp)*.00117*1000),4,1), RB,,, RGB(255,165,0)
    
    Text MM.HRes*23/40, MM.VRes*5/16, "Ambient     = ", LB,,, RGB(Cyan)
    Text MM.HRes*23/40, MM.VRes*6/16, "Evaporator  = ", LB,,, RGB(Green)
    Text MM.HRes*23/40, MM.VRes*7/16, "Input       = ", LB,,, RGB(Blue)
    Text MM.HRes*23/40, MM.VRes*8/16, "Output      = ", LB,,, RGB(Red)
    Text MM.HRes*23/40, MM.VRes*9/16, "Temp Diff   = ", LB,,, RGB(Magenta)
    Text MM.HRes*23/40, MM.VRes*10/16, "Compressor  = ", LB,,, RGB(Yellow)
    
    
    Text MM.HRes*39/40, MM.VRes*5/16, Str$(TmpHpAir,4,1), RB,,, RGB(Cyan)
    Text MM.HRes*39/40, MM.VRes*6/16, Str$(TmpHpEva,4,1), RB,,, RGB(Green)
    Text MM.HRes*39/40, MM.VRes*7/16, Str$(TmpHpInp,4,1), RB,,, RGB(Blue)
    Text MM.HRes*39/40, MM.VRes*8/16, Str$(TmpHpOut,4,1), RB,,, RGB(Red)
    Text MM.HRes*39/40, MM.VRes*9/16, Str$(TmpHpOut-TmpHPInp,4,1), RB,,, RGB(Magenta)
    Text MM.HRes*39/40, MM.VRes*10/16, Str$(TmpHpCmp,4,1), RB,,, RGB(Yellow)
    
    
    Text MM.HRes/2, MM.VRes*14/16, "Current Time", CB,,, RGB(White)
    Text MM.HRes*1/4, MM.VRes*14/16, "LastScComs", CB,,, RGB(White)
    Text MM.HRes*3/4, MM.VRes*14/16, "LastHpComs", CB,,, RGB(White)
    
    Text MM.HRes/2, MM.VRes*15/16, Time$, CB,,, RGB(White)
    Text MM.HRes*1/4, MM.VRes*15/16, LastScComs, CB,,, RGB(White)
    Text MM.HRes*3/4, MM.VRes*15/16, LastHpComs, CB,,, RGB(White)
    Text MM.HRes/2, MM.VRes*16/16, Date$, CB,,, RGB(White)
    
    'Text MM.HRes/2, MM.VRes*10/16, SecsTime(PumpRunTime), CB,,, RGB(Green)
    'Circle 304,224,15,0,,,Led2Colour 'Right LED
    'RBOX 279,209,40,30,4,,Led2Colour
    
    
    If TabAct<>4 Then
      Cls
      Print "Clear Screen"
      Gui Show All
    End If
  End if
End Sub
  
Sub TouchDown
  
  Print "TouchDown"
  
  Select Case Touch(REF) ' find out the control touched
    Case 1
      Print CtrlVal(SwT1),"Button 1 Pressed"
      If TabAct=4 Then
        Cls
        'Gui Show All
      End If
      TabAct=1
      Page 1,9
      Gui Show All
    Case 2
      Print CtrlVal(SwT2),"Button 2 Pressed"
      If TabAct=4 Then
        Cls
        'Gui Show All
      End If
      TabAct=2
      Page 2,9
      Gui Show All
    Case 3
      Print CtrlVal(SwT3),"Button 3 Pressed"
      If TabAct=4 Then
        Cls
        'Gui Show All
      End If
      TabAct=3
      Page 3,9
      Gui Show All
    Case 4
      Print CtrlVal(SwT4),"Button 4 Pressed"
      TabAct=4
      Page 4,9
      '      Cls
      '      Gui Show All
      UpdateTab4
  End Select
  
  Select Case TabAct
    Case 1
      CtrlVal(SwT1)=0
      CtrlVal(SwT2)=1
      CtrlVal(SwT3)=1
      CtrlVal(SwT4)=1
    Case 2
      CtrlVal(SwT1)=1
      CtrlVal(SwT2)=0
      CtrlVal(SwT3)=1
      CtrlVal(SwT4)=1
    Case 3
      CtrlVal(SwT1)=1
      CtrlVal(SwT2)=1
      CtrlVal(SwT3)=0
      CtrlVal(SwT4)=1
    Case 4
      CtrlVal(SwT1)=1
      CtrlVal(SwT2)=1
      CtrlVal(SwT3)=1
      CtrlVal(SwT4)=0
  End Select
  Print "TabAct";TabAct
  
End Sub
  
Sub SetupGui
  Cls
  Font 4
  TabHgt=MM.VRes/8
  
  'Heading Buttons
  GUI SETUP 9
  GUI Switch SwT1, "Home Page", MM.HRes/4*0,0,MM.Hres/4-2,TabHgt, RGB(Cyan),RGB(Gray)
  CtrlVal(SwT1)=0
  GUI Switch SwT2, "2nd Page",MM.HRes/4*1,0,MM.Hres/4-2,TabHgt, RGB(White)
  CtrlVal(SwT2)=1
  GUI Switch SwT3, "3rd Page",MM.HRes/4*2,0,MM.Hres/4-2,TabHgt, RGB(White)
  CtrlVal(SwT3)=1
  GUI Switch SwT4, "Full Detail",MM.HRes/4*3,0,MM.Hres/4-2,TabHgt, RGB(White)
  CtrlVal(SwT4)=1
  
  'Page #1
  GUI SETUP 1
  'GUI Displaybox 5, 0,TabHgt+1,MM.HRes/2,TabHgt/2
  'CtrlVal(5)="First Tab"
  
  Font 4
  Gui Frame 99,"Temperatures",MM.HRes/80,MM.VRes*3.5/16,MM.FontWidth*15,MM.FontHeight*9,RGB(White)
  Gui Caption C_TmpAmb,"Air    ",MM.HRes/40, MM.VRes*5/16,LB,RGB(Cyan) : Gui Displaybox D_TmpAmb,MM.HRes*7/40,MM.VRes*4/16,MM.FontWidth*6,MM.VRes/16,,0
  Gui Caption C_TmpCur,"Water  ",MM.HRes/40, MM.VRes*6/16,LB,RGB(Green) : Gui Displaybox D_TmpCur,MM.HRes*7/40,MM.VRes*5/16,MM.FontWidth*6,MM.VRes/16
  Gui Caption C_TmpInp,"Input  ",MM.HRes/40, MM.VRes*7/16,LB,RGB(Blue) : Gui Displaybox D_TmpInp,MM.HRes*7/40,MM.VRes*6/16,MM.FontWidth*6,MM.VRes/16
  Gui Caption C_TmpOut,"Output ",MM.HRes/40, MM.VRes*8/16,LB,RGB(Red) : Gui Displaybox D_TmpOut,MM.HRes*7/40,MM.VRes*7/16,MM.FontWidth*6,MM.VRes/16
  Gui Caption C_TmpDif,"Diff   ",MM.HRes/40, MM.VRes*9/16,LB,RGB(Magenta) : Gui Displaybox D_TmpDif,MM.HRes*7/40,MM.VRes*8/16,MM.FontWidth*6,MM.VRes/16
  Gui Caption C_TmpPan,"Panel   ",MM.HRes/40, MM.VRes*10/16,LB,RGB(Magenta) : Gui Displaybox D_TmpPan,MM.HRes*7/40,MM.VRes*9/16,MM.FontWidth*6,MM.VRes/16
 
  
  
  'Page #2
  GUI SETUP 2
  GUI Displaybox 6, 0,TabHgt+1,MM.HRes/2,TabHgt
  CtrlVal(6)="Second Tab"
  ' the flow rate display box
  Font 3 : GUI Caption 9, "Flow Rate", 20, 170,, RGB(brown),0
  Font 4 : GUI Displaybox 10, 20, 200, 150, 45
  'CtrlVal(10) = "20.1"
  GUI Numberbox 11, 318,MM.VPos-6,90,MM.FontHeight+12,RGB(yellow),RGB(64,64,64)
  
  'Page #3
  GUI SETUP 3
  GUI Displaybox 7, 0,TabHgt+1,MM.HRes/2,TabHgt
  CtrlVal(7)="Third Tab"
  
  'Page #4
  GUI SETUP 4
  GUI Displaybox D_Head4, 0,TabHgt+1,MM.HRes,TabHgt/2
  Gui Frame F_SpaDat,"Spa Sensors",MM.HRes*0/80,MM.VRes*3.5/16,MM.FontWidth*22,MM.VRes*9/16,RGB(White)
  'Gui Frame F_HtpDat,"Heat Pump Sensors",MM.HRes*40/80,MM.VRes*3.5/16,MM.FontWidth*22,MM.VRes*9/16,RGB(White)
  Gui Frame F_HtpDat,"Heat Pump Sensors",MM.HRes-MM.FontWidth*22,MM.VRes*3.5/16,MM.FontWidth*22,MM.VRes*9/16,RGB(White)
  
  CtrlVal(D_Head4)="Detailed Output - All Sensors"
  
  'GUI LED L_Led1,"",0,419,60,RGB(Yellow)     Incorrect Syntax was specified in 5.2
  'GUI LED L_Led2,"",739,419,60,RGB(Yellow)
  GUI LED L_Led1,"",30,449,30,RGB(Yellow)
  GUI LED L_Led2,"",769,449,30,RGB(Yellow)
  
End Sub
  
